-- Usuários áreas (vincula usuário a áreas internas)
CREATE TABLE IF NOT EXISTS usuarios_areas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_id INT NOT NULL,
    area ENUM('desenvolvimento','suporte','tecnico_campo','administrativo','financeiro') NOT NULL,
    criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
) ENGINE=InnoDB;

-- Tarefas de desenvolvimento (bugs / features)
CREATE TABLE IF NOT EXISTS tarefas_desenvolvimento (
    id INT AUTO_INCREMENT PRIMARY KEY,
    titulo VARCHAR(255) NOT NULL,
    descricao TEXT,
    prioridade ENUM('baixa','media','alta','critica') DEFAULT 'media',
    status ENUM('novo','andamento','testando','aguardando','finalizado') DEFAULT 'novo',
    criado_por INT,
    atribuido_a INT NULL,
    criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
    atualizado_em DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (criado_por) REFERENCES usuarios(id) ON DELETE SET NULL,
    FOREIGN KEY (atribuido_a) REFERENCES usuarios(id) ON DELETE SET NULL
) ENGINE=InnoDB;

-- Agenda de técnicos de campo
CREATE TABLE IF NOT EXISTS agendamentos_campo (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tecnico_id INT NOT NULL,
    empresa_id INT NOT NULL,
    data_visita DATE NOT NULL,
    horario_inicio TIME NULL,
    horario_fim TIME NULL,
    status ENUM('agendado','em_andamento','concluido','cancelado') DEFAULT 'agendado',
    observacoes TEXT NULL,
    criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (tecnico_id) REFERENCES usuarios(id) ON DELETE CASCADE,
    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE
) ENGINE=InnoDB;

-- Financeiro: contratos e pagamentos
CREATE TABLE IF NOT EXISTS financeiro_contratos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    empresa_id INT NOT NULL,
    descricao VARCHAR(255),
    valor DECIMAL(12,2) NOT NULL DEFAULT 0,
    inicio DATE,
    fim DATE,
    ativo TINYINT(1) DEFAULT 1,
    criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS financeiro_pagamentos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    contrato_id INT NOT NULL,
    data_vencimento DATE,
    data_pagamento DATE NULL,
    valor DECIMAL(12,2) NOT NULL DEFAULT 0,
    status ENUM('pendente','pago','atrasado') DEFAULT 'pendente',
    criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (contrato_id) REFERENCES financeiro_contratos(id) ON DELETE CASCADE
) ENGINE=InnoDB;
