-- Relatórios técnicos
CREATE TABLE IF NOT EXISTS relatorios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    empresa_id INT NOT NULL,
    tecnico_id INT NOT NULL,
    data_visita DATE NOT NULL,
    periodo VARCHAR(100) NULL,
    responsavel VARCHAR(150) NULL,
    resumo_executivo TEXT NULL,
    criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (empresa_id) REFERENCES empresas(id) ON DELETE CASCADE,
    FOREIGN KEY (tecnico_id) REFERENCES usuarios(id) ON DELETE SET NULL
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS relatorio_itens (
    id INT AUTO_INCREMENT PRIMARY KEY,
    relatorio_id INT NOT NULL,
    titulo VARCHAR(255) NULL,
    atividades TEXT NULL,
    ocorrencias TEXT NULL,
    observacoes TEXT NULL,
    situacao_atual TEXT NULL,
    pendencias TEXT NULL,
    ordenacao INT DEFAULT 0,
    FOREIGN KEY (relatorio_id) REFERENCES relatorios(id) ON DELETE CASCADE
) ENGINE=InnoDB;
