<?php
require_once __DIR__ . '/Database.php';

class Auth {

    public static function login($email, $senha) {
        $pdo = Database::getConnection();

        $sql = $pdo->prepare("SELECT * FROM usuarios WHERE email = ? LIMIT 1");
        $sql->execute([$email]);

        $user = $sql->fetch(PDO::FETCH_ASSOC);

        if (!$user) {
            return false;
        }

        if (!password_verify($senha, $user['senha'])) {
            return false;
        }

        // Segurança extra em servidor
        session_regenerate_id(true);

        $_SESSION['usuario_id'] = $user['id'];
        $_SESSION['usuario_nome'] = $user['nome'];
        $_SESSION['usuario_nivel'] = $user['nivel'];

        return true;
    }

    public static function check() {
        return isset($_SESSION['usuario_id']);
    }

    public static function logout() {
        session_destroy();
    }
}
