<?php
require_once __DIR__ . '/Config.php';

class Database {
    private static $instance;

    public static function getConnection() {
        if (!self::$instance) {
            try {
                $dsn = "mysql:host=" . Config::DB_HOST . ";dbname=" . Config::DB_NAME . ";charset=utf8";
                self::$instance = new PDO($dsn, Config::DB_USER, Config::DB_PASS);
                self::$instance->setAttribute(PDO::ATTR_ERRMODE, Config::DEBUG ? PDO::ERRMODE_EXCEPTION : PDO::ERRMODE_SILENT);
            } catch (PDOException $e) {
                die("Erro ao conectar ao banco: " . $e->getMessage());
            }
        }
        return self::$instance;
    }
}
