<?php
namespace App\controllers;
use App\models\Contrato;
use App\models\Pagamento;
use App\Auth;
use function App\verify_csrf;
class FinanceController {
    public function index(){
        if(!Auth::check()){ header('Location:/login'); exit; }
        $contracts = Contrato::all();
        include __DIR__ . '/../views/finance/index.php';
    }
    public function createContract(){
        if(!Auth::check()){ header('Location:/login'); exit; }
        if($_SERVER['REQUEST_METHOD']==='POST'){
            verify_csrf();
            $id = Contrato::create($_POST);
            header('Location: /finance'); exit;
        }
        include __DIR__ . '/../views/finance/create_contract.php';
    }
    public function createPayment(){
        if(!Auth::check()){ header('Location:/login'); exit; }
        if($_SERVER['REQUEST_METHOD']==='POST'){
            verify_csrf();
            $id = Pagamento::create($_POST);
            header('Location: /finance'); exit;
        }
        include __DIR__ . '/../views/finance/create_payment.php';
    }
}
