<?php
namespace App\controllers;

use App\models\Relatorio;
use App\models\RelatorioItem;
use App\models\Company;
use App\models\User;
use App\Auth;
use function App\verify_csrf;
use function App\log_action;

class RelatorioController {
    public function index() {
        $this->ensureAuthenticated();
        $filters = [];
        if (!empty($_GET['empresa_id'])) $filters['empresa_id'] = $_GET['empresa_id'];
        if (!empty($_GET['tecnico_id'])) $filters['tecnico_id'] = $_GET['tecnico_id'];
        if (!empty($_GET['data_from'])) $filters['data_from'] = $_GET['data_from'];
        if (!empty($_GET['data_to'])) $filters['data_to'] = $_GET['data_to'];
        $relatorios = Relatorio::all($filters);
        $empresas = Company::all();
        $tecnicos = User::all();
        include __DIR__ . '/../views/relatorio/list.php';
    }

    public function create() {
        $this->ensureAuthenticated();
        $empresas = Company::all();
        $tecnicos = User::all();
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            verify_csrf();
            $data = $_POST;
            $rData = [
                'empresa_id' => $data['empresa_id'],
                'tecnico_id' => $data['tecnico_id'],
                'data_visita' => $data['data_visita'],
                'periodo' => $data['periodo'] ?? null,
                'responsavel' => $data['responsavel'] ?? null,
                'resumo_executivo' => $data['resumo_executivo'] ?? null
            ];
            $rid = Relatorio::create($rData);
            $titulos = $data['item_titulo'] ?? [];
            $atividades = $data['item_atividades'] ?? [];
            $ocorrencias = $data['item_ocorrencias'] ?? [];
            $observacoes = $data['item_observacoes'] ?? [];
            $situacoes = $data['item_situacao'] ?? [];
            $pendencias = $data['item_pendencias'] ?? [];
            foreach ($titulos as $i => $titulo) {
                if (trim($titulo) === '' && trim($atividades[$i] ?? '') === '') continue;
                $item = [
                    'titulo' => $titulo,
                    'atividades' => $atividades[$i] ?? null,
                    'ocorrencias' => $ocorrencias[$i] ?? null,
                    'observacoes' => $observacoes[$i] ?? null,
                    'situacao_atual' => $situacoes[$i] ?? null,
                    'pendencias' => $pendencias[$i] ?? null,
                    'ordenacao' => $i
                ];
                RelatorioItem::create($rid, $item);
            }
            log_action('relatorio', 'Relatorio criado ID ' . $rid);
            header('Location: /relatorios/view?id=' . $rid);
            exit;
        }
        include __DIR__ . '/../views/relatorio/create.php';
    }

    public function view() {
        $this->ensureAuthenticated();
        $id = $_GET['id'] ?? null;
        if (!$id) { header('Location: /relatorios'); exit; }
        $relatorio = Relatorio::find($id);
        $itens = RelatorioItem::listByRelatorio($id);
        include __DIR__ . '/../views/relatorio/view.php';
    }

    public function exportPdf() {
        $this->ensureAuthenticated();
        $id = $_GET['id'] ?? null;
        if (!$id) { header('Location: /relatorios'); exit; }
        $relatorio = Relatorio::find($id);
        $itens = RelatorioItem::listByRelatorio($id);
        include __DIR__ . '/../views/relatorio/export_pdf.php';
    }

    private function ensureAuthenticated() {
        if (!Auth::check()) { header('Location: /login'); exit; }
    }
}
