<?php
namespace App;

function url($path = '/') {
    $base = rtrim(Config::env('APP_URL', ''), '/');
    return $base . '/' . ltrim($path, '/');
}

function redirect($path) {
    header('Location: ' . $path);
    exit;
}

function e($v) { return htmlspecialchars($v ?? '', ENT_QUOTES, 'UTF-8'); }

function csrf_token() {
    if (session_status() === PHP_SESSION_NONE) session_start();
    if (empty($_SESSION['_csrf_token'])) {
        $_SESSION['_csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['_csrf_token'];
}

function csrf_field() {
    $t = csrf_token();
    return '<input type="hidden" name="_csrf" value="' . $t . '" />';
}

function verify_csrf() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (session_status() === PHP_SESSION_NONE) session_start();
        $token = $_POST['_csrf'] ?? '';
        if (!$token || !hash_equals($_SESSION['_csrf_token'] ?? '', $token)) {
            http_response_code(400);
            die('CSRF token inválido.');
        }
    }
}

function log_action($tipo, $mensagem) {
    $pdo = Database::get();
    $stmt = $pdo->prepare('INSERT INTO logs (tipo,mensagem) VALUES (?,?)');
    $stmt->execute([$tipo, $mensagem]);
}
