<?php
namespace App\models;
use App\Database;
use PDO;

class RelatorioItem {
    public static function create($relatorio_id, $data) {
        $pdo = Database::get();
        $stmt = $pdo->prepare('INSERT INTO relatorio_itens (relatorio_id,titulo,atividades,ocorrencias,observacoes,situacao_atual,pendencias,ordenacao) VALUES (?,?,?,?,?,?,?,?)');
        $stmt->execute([$relatorio_id,$data['titulo'] ?? null,$data['atividades'] ?? null,$data['ocorrencias'] ?? null,$data['observacoes'] ?? null,$data['situacao_atual'] ?? null,$data['pendencias'] ?? null,$data['ordenacao'] ?? 0]);
        return $pdo->lastInsertId();
    }

    public static function listByRelatorio($relatorio_id) {
        $pdo = Database::get();
        $stmt = $pdo->prepare('SELECT * FROM relatorio_itens WHERE relatorio_id = ? ORDER BY ordenacao ASC, id ASC');
        $stmt->execute([$relatorio_id]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
