<?php
namespace App\models;
use App\Database;
use PDO;

class Relatorio {
    public static function create($data) {
        $pdo = Database::get();
        $stmt = $pdo->prepare('INSERT INTO relatorios (empresa_id, tecnico_id, data_visita, periodo, responsavel, resumo_executivo) VALUES (?,?,?,?,?,?)');
        $stmt->execute([$data['empresa_id'],$data['tecnico_id'],$data['data_visita'],$data['periodo'] ?? null,$data['responsavel'] ?? null,$data['resumo_executivo'] ?? null]);
        return $pdo->lastInsertId();
    }

    public static function find($id) {
        $pdo = Database::get();
        $stmt = $pdo->prepare('SELECT r.*, e.nome as empresa_nome, u.nome as tecnico_nome FROM relatorios r LEFT JOIN empresas e ON r.empresa_id = e.id LEFT JOIN usuarios u ON r.tecnico_id = u.id WHERE r.id = ?');
        $stmt->execute([$id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function all($filters = []) {
        $pdo = Database::get();
        $sql = 'SELECT r.*, e.nome as empresa_nome, u.nome as tecnico_nome FROM relatorios r LEFT JOIN empresas e ON r.empresa_id = e.id LEFT JOIN usuarios u ON r.tecnico_id = u.id';
        $conds = [];
        $params = [];
        if (!empty($filters['empresa_id'])) { $conds[] = 'r.empresa_id = ?'; $params[] = $filters['empresa_id']; }
        if (!empty($filters['tecnico_id'])) { $conds[] = 'r.tecnico_id = ?'; $params[] = $filters['tecnico_id']; }
        if (!empty($filters['data_from'])) { $conds[] = 'r.data_visita >= ?'; $params[] = $filters['data_from']; }
        if (!empty($filters['data_to'])) { $conds[] = 'r.data_visita <= ?'; $params[] = $filters['data_to']; }
        if ($conds) $sql .= ' WHERE ' . implode(' AND ', $conds);
        $sql .= ' ORDER BY r.data_visita DESC, r.criado_em DESC';
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
