<?php include __DIR__ . '/../layout/header.php'; ?>
<div class="container mt-4">
  <h3>Novo Relatório Técnico</h3>
  <form method="post" action="/relatorios/create">
    <?= \App\csrf_field() ?>
    <div class="row">
      <div class="col-md-4 mb-3"><label>Empresa</label>
        <select name="empresa_id" class="form-control" required>
          <option value="">-- Selecione --</option>
          <?php foreach ($empresas as $e): ?>
            <option value="<?= e($e['id']) ?>"><?= e($e['nome']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4 mb-3"><label>Técnico</label>
        <select name="tecnico_id" class="form-control" required>
          <option value="">-- Selecione --</option>
          <?php foreach ($tecnicos as $t): ?>
            <option value="<?= e($t['id']) ?>"><?= e($t['nome']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4 mb-3"><label>Data da Visita</label>
        <input type="date" name="data_visita" class="form-control" required>
      </div>
    </div>

    <div class="mb-3"><label>Período</label><input class="form-control" name="periodo"></div>
    <div class="mb-3"><label>Responsável</label><input class="form-control" name="responsavel"></div>

    <hr>
    <h5>Itens (Condomínios)</h5>
    <div id="itens-wrapper">
      <div class="rel-item card mb-3 p-3">
        <div class="mb-2"><label>Nome do Condomínio</label><input name="item_titulo[]" class="form-control"></div>
        <div class="mb-2"><label>Atividades Executadas</label><textarea name="item_atividades[]" class="form-control" rows="3"></textarea></div>
        <div class="mb-2"><label>Ocorrências</label><textarea name="item_ocorrencias[]" class="form-control" rows="2"></textarea></div>
        <div class="mb-2"><label>Observações / Situação</label><textarea name="item_observacoes[]" class="form-control" rows="2"></textarea></div>
        <div class="mb-2"><label>Pendências</label><textarea name="item_pendencias[]" class="form-control" rows="2"></textarea></div>
        <button type="button" class="btn btn-danger btn-sm remove-item">Remover</button>
      </div>
    </div>
    <div class="mb-3"><button type="button" id="add-item" class="btn btn-outline-primary">Adicionar Condomínio</button></div>

    <div class="mb-3"><label>Resumo Executivo</label><textarea name="resumo_executivo" class="form-control" rows="6"></textarea></div>

    <button class="btn btn-primary">Salvar Relatório</button>
  </form>
</div>
<?php include __DIR__ . '/../layout/footer.php'; ?>
<script>
document.getElementById('add-item').addEventListener('click', function(){
  const wrapper = document.getElementById('itens-wrapper');
  const node = document.querySelector('.rel-item').cloneNode(true);
  node.querySelectorAll('input,textarea').forEach(i=>i.value='');
  wrapper.appendChild(node);
});
document.addEventListener('click', function(e){ if(e.target.matches('.remove-item')) e.target.closest('.rel-item').remove(); });
</script>
