<?php
// require composer autoload (dompdf)
require_once __DIR__ . '/../../../vendor/autoload.php';
use Dompdf\Dompdf;
ob_start();
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <style>
    body{font-family: DejaVu Sans, sans-serif; font-size:12px}
    h2{font-size:16px}
    .section{margin-bottom:14px}
    .title{font-weight:bold}
    .sep{border-top:1px solid #ccc; margin:10px 0}
  </style>
</head>
<body>
  <h2>RELATÓRIO DE ATIVIDADES – VISITAS TÉCNICAS E INTERVENÇÕES</h2>
  <p><strong>Período:</strong> <?= e($relatorio['periodo'] ?: $relatorio['data_visita']) ?><br>
  <strong>Responsável:</strong> <?= e($relatorio['responsavel']) ?><br>
  <strong>Empresa:</strong> <?= e($relatorio['empresa_nome']) ?></p>

  <?php foreach ($itens as $it): ?>
    <div class="section">
      <p class="title">✅ <?= e($it['titulo']) ?></p>
      <?php if($it['atividades']): ?><p><strong>Atividades Executadas:</strong><br><?= nl2br(e($it['atividades'])) ?></p><?php endif; ?>
      <?php if($it['observacoes']): ?><p><strong>Observações e Necessidades:</strong><br><?= nl2br(e($it['observacoes'])) ?></p><?php endif; ?>
      <?php if($it['ocorrencias']): ?><p><strong>Ocorrências:</strong><br><?= nl2br(e($it['ocorrencias'])) ?></p><?php endif; ?>
      <?php if($it['pendencias']): ?><p><strong>Pendências:</strong><br><?= nl2br(e($it['pendencias'])) ?></p><?php endif; ?>
      <div class="sep"></div>
    </div>
  <?php endforeach; ?>

  <?php if($relatorio['resumo_executivo']): ?>
    <h3>RESUMO EXECUTIVO</h3>
    <p><?= nl2br(e($relatorio['resumo_executivo'])) ?></p>
  <?php endif; ?>
</body>
</html>
<?php
$html = ob_get_clean();
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream('relatorio_' . $relatorio['id'] . '.pdf', ['Attachment' => 0]);
exit;
