<?php include __DIR__ . '/../layout/header.php'; ?>
<div class="container mt-4">
  <h3>Relatórios Técnicos</h3>
  <div class="mb-3">
    <a href="/relatorios/create" class="btn btn-success">Novo Relatório</a>
  </div>
  <table class="table table-striped">
    <thead><tr><th>#</th><th>Data</th><th>Empresa</th><th>Técnico</th><th>Criado</th><th>Ações</th></tr></thead>
    <tbody>
      <?php foreach ($relatorios as $r): ?>
        <tr>
          <td><?= e($r['id']) ?></td>
          <td><?= e($r['data_visita']) ?></td>
          <td><?= e($r['empresa_nome']) ?></td>
          <td><?= e($r['tecnico_nome']) ?></td>
          <td><?= e($r['criado_em']) ?></td>
          <td>
            <a class="btn btn-sm btn-primary" href="/relatorios/view?id=<?= e($r['id']) ?>">Visualizar</a>
            <a class="btn btn-sm btn-outline-secondary" href="/relatorios/export?id=<?= e($r['id']) ?>">Exportar PDF</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php include __DIR__ . '/../layout/footer.php'; ?>
