<?php include __DIR__ . '/../layout/header.php'; ?>
<div class="container mt-4">
  <div class="d-flex justify-content-between">
    <h3>Relatório #<?= e($relatorio['id']) ?> - <?= e($relatorio['empresa_nome']) ?></h3>
    <div>
      <a class="btn btn-outline-secondary" href="/relatorios/export?id=<?= e($relatorio['id']) ?>">Exportar PDF</a>
    </div>
  </div>
  <p><strong>Data:</strong> <?= e($relatorio['data_visita']) ?> | <strong>Responsável:</strong> <?= e($relatorio['responsavel']) ?></p>
  <?php foreach ($itens as $it): ?>
    <div class="card mb-3">
      <div class="card-body">
        <h5>✅ <?= e($it['titulo']) ?></h5>
        <?php if($it['atividades']): ?><p><strong>Atividades Executadas:</strong><br><?= nl2br(e($it['atividades'])) ?></p><?php endif; ?>
        <?php if($it['ocorrencias']): ?><p><strong>Ocorrências:</strong><br><?= nl2br(e($it['ocorrencias'])) ?></p><?php endif; ?>
        <?php if($it['observacoes']): ?><p><strong>Observações:</strong><br><?= nl2br(e($it['observacoes'])) ?></p><?php endif; ?>
        <?php if($it['pendencias']): ?><p><strong>Pendências:</strong><br><?= nl2br(e($it['pendencias'])) ?></p><?php endif; ?>
      </div>
    </div>
  <?php endforeach; ?>

  <?php if($relatorio['resumo_executivo']): ?>
    <div class="card"><div class="card-body"><h5>Resumo Executivo</h5><p><?= nl2br(e($relatorio['resumo_executivo'])) ?></p></div></div>
  <?php endif; ?>
</div>
<?php include __DIR__ . '/../layout/footer.php'; ?>
